timesteps = 300;    
h = 0.3;
r = 2;
d = 0.2;
s = 0.5; %sigma

alphas = [0.9, 0.8, 0.7, 0.6]; 

colors = {
    [1 0 0],        % red
    [0.85 0.65 0],  % dark yellow
    [0 0.5 0],      % dark green
    [0 0 0]         % black
};



t = (0:timesteps);

figure;
hold on;

for k = 1:length(alphas)
    alpha_k = alphas(k);
    h1 = h^alpha_k / gamma(1 + alpha_k);

    x = zeros(1, timesteps+1);
    y = zeros(1, timesteps+1);
    x(1) = 0.31;
    y(1) = 2;

    for n = 1:timesteps
        x(n+1) = x(n) + h1 * ( r*x(n) - x(n)*y(n) );
        y(n+1) = y(n) + h1 * ( s - (1/r)*y(n) - d*x(n) + x(n)*y(n) );
    end

    plot(t, x, '.','markersize',8, 'Color', colors{k});
end

hold off;

xlabel('n', 'FontSize', 14, 'Color', [0 0 0]);
ylabel('N(n)', 'FontSize', 14, 'Color', [0 0 0]);


hLegend = legend(  ['\alpha = ' num2str(alphas(1))],  ['\alpha = ' num2str(alphas(2))],  ['\alpha = ' num2str(alphas(3))], ['\alpha = ' num2str(alphas(4))], ...
    'Location', 'best');

set(hLegend, 'FontSize', 14);   
set(hLegend, 'LineWidth', 1.5); 

set(gca, 'XColor', [0 0 0], 'YColor', [0 0 0]); 
set(gca, 'LineWidth', 1.5); 


set(gca, 'FontSize',20);

